;NSIS Modern User Interface
;Basic Example Script
;Written by Joost Verburg

;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

;--------------------------------
;General

  ;Name and file
  Name "BackgroundPSH"
  OutFile "BP_Setup.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\BackgroundPSH"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\BackgroundPSH" ""

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_LICENSE "license.txt"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES

    # These indented statements modify settings for MUI_PAGE_FINISH
    !define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
    !define MUI_FINISHPAGE_SHOWREADME $INSTDIR\readme.txt
    !define MUI_FINISHPAGE_TEXT "You may now use the extension by right clicking folder background."
    !define MUI_FINISHPAGE_LINK "BackgroundPSH's Website - Worth Your While"
    !define MUI_FINISHPAGE_LINK_LOCATION http://www.roggel.com/NGNeer/BackgroundPSH/
    !define MUI_FINISHPAGE_NOREBOOTSUPPORT
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "BackgroundPSH" SecBP

  SectionIn RO

  SetOutPath "$INSTDIR"
  
  ; transfer program file
  File "BackgroundPSH.dll"
  ; transfer readme file
  File "readme.txt"
  
  ;Store installation folder
  WriteRegStr HKCU "Software\BackgroundPSH" "" $INSTDIR

  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BackgroundPSH" "DisplayName" "BackgroundPSH Shell Extension"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BackgroundPSH" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BackgroundPSH" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BackgroundPSH" "NoRepair" 1
  
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\uninstall.exe"

  ; and register dll
  Exec '"regsvr32.exe" /s "$INSTDIR\BackgroundPSH.dll"'
SectionEnd

; start menu shortcuts section (optional)
Section "Start Menu Shortcuts" SecSM
  CreateDirectory "$SMPROGRAMS\BackgroundPSH"
  CreateShortCut "$SMPROGRAMS\BackgroundPSH\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\BackgroundPSH\Readme.lnk" "$INSTDIR\readme.txt" "" "$INSTDIR\readme.txt" 0
SectionEnd

;--------------------------------
;Descriptions

  ;Language strings
  LangString DESC_SecBP ${LANG_ENGLISH} "BackgroundPSH extension DLL file."

  LangString DESC_SecSM ${LANG_ENGLISH} "Set up start menu shortcuts. These include viewing the \
	readme file and uninstalling the extension. Regardless, uninstallation is always available \
	from the Add/Remove Programs Dialog."

  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecDG} $(DESC_SecDG)
    !insertmacro MUI_DESCRIPTION_TEXT ${SecSM} $(DESC_SecSM)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ; unregister dll
  Exec '"regsvr32.exe" /u /s "$INSTDIR\BackgroundPSH.dll"'

  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BackgroundPSH"
  DeleteRegKey /ifempty HKCU "Software\BackgroundPSH"

  ; remove files and uninstaller
  Delete "$INSTDIR\BackgroundPSH.dll"
  Delete "$INSTDIR\readme.txt"
  Delete "$INSTDIR\uninstall.exe"

  ; remove shortcuts (if any)
  Delete "$SMPROGRAMS\BackgroundPSH\*.*"

  ; remove shortcut directory
  RMDir "$SMPROGRAMS\BackgroundPSH"

  ; remove installation directory
  RMDir "$INSTDIR"

SectionEnd
